/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Triple;

public class ActionOnBlockBreakPower
extends Power {
    private final Predicate<CachedBlockInfo> blockCondition;
    private final Consumer<Entity> entityAction;
    private final Consumer<Triple<World, BlockPos, Direction>> blockAction;
    private final boolean onlyWhenHarvested;

    public ActionOnBlockBreakPower(PowerType<?> type, PlayerEntity player, Predicate<CachedBlockInfo> blockCondition, Consumer<Entity> entityAction, Consumer<Triple<World, BlockPos, Direction>> blockAction, boolean onlyWhenHarvested) {
        super(type, player);
        this.blockCondition = blockCondition;
        this.entityAction = entityAction;
        this.blockAction = blockAction;
        this.onlyWhenHarvested = onlyWhenHarvested;
    }

    public boolean doesApply(BlockPos pos) {
        CachedBlockInfo cbp = new CachedBlockInfo((IWorldReader)this.player.field_70170_p, pos, true);
        return this.doesApply(cbp);
    }

    public boolean doesApply(CachedBlockInfo pos) {
        return this.blockCondition == null || this.blockCondition.test(pos);
    }

    public void executeActions(boolean successfulHarvest, BlockPos pos, Direction dir) {
        if (successfulHarvest || !this.onlyWhenHarvested) {
            if (this.blockAction != null) {
                this.blockAction.accept((Triple<World, BlockPos, Direction>)Triple.of((Object)this.player.field_70170_p, (Object)pos, (Object)dir));
            }
            if (this.entityAction != null) {
                this.entityAction.accept((Entity)this.player);
            }
        }
    }
}

